/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238.DeviceView;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8238.DeviceView.Builder;
import ibm.nways.jdm8238.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8238.DeviceView.ChassisLike;
import ibm.nways.jdm8238.DeviceView.LateStatusLike;
import ibm.nways.jdm8238.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8238.DeviceView.ModuleLike;
import ibm.nways.jdm8238.DeviceView.StatusAttachInfo;
import ibm.nways.jdm8238.DeviceView.StatusRefLike;
import ibm.nways.jdm8238.Jdm8238;
import ibm.nways.jdm8238.MibInfo;
import ibm.nways.jdm8238.MibValue;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class Chassis
implements ChassisLike,
ChassisInfoLike {
    private final Vector components = new Vector();
    private Vector interfaceModels;
    protected GenModel interfaceGenModel;
    private GraphicPanel graphicPanel;
    private String cookieId;
    protected JdmBrowser jdmBrowser;
    protected MibInfo snmpInfo;
    protected ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.jdm8238.DeviceView.GraphicResources");
    protected GraphicContainer graphicContainer = new GraphicContainer();
    protected GraphicContainer container = new GraphicContainer();
    protected StatusAttachThread statusThread;
    protected Vector stack = new Vector();
    protected Vector lateStack = new Vector();
    protected Hashtable macAddressTokenRingPorts;

    public void dispose() {
        if (this.statusThread != null) {
            this.statusThread.stop();
            this.statusThread = null;
        }
        this.stack.removeAllElements();
        this.lateStack.removeAllElements();
        this.jdmBrowser = null;
        this.components.removeAllElements();
    }

    public JdmBrowser getBrowser() {
        return this.jdmBrowser;
    }

    public MibInfo getMibInfo() {
        return this.snmpInfo;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void discoverChildren() {
        if (RAS.isEnabled(19, 5)) {
            RAS.enter(19, 5, this, "discoverChildren");
        }
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            genModel = (GenModel)genModel.getComponent("Modules");
            Vector vector = genModel.getRestOfInfo("_Empty", "default", null, null);
            Serializable serializable = this.snmpInfo.getVar("modType");
            if (serializable instanceof Vector) {
                Object object;
                Object object2;
                Object object3;
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "discoverChildren", "Modules found in HUB");
                }
                Vector vector2 = (Vector)serializable;
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "discoverChildren", "Found " + vector2.size() + " module(s)");
                }
                Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>(8);
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    MibValue mibValue = (MibValue)enumeration.nextElement();
                    int[] nArray = mibValue.getIndexesArray();
                    Integer n = new Integer(nArray[0]);
                    Integer n2 = new Integer(-1);
                    try {
                        object3 = ((Jdm8238)this.jdmBrowser).getProperties();
                        object2 = new String(n.toString());
                        object = (String)((Hashtable)object3).get("ModuleLocation." + (String)object2);
                        n2 = new Integer((String)object);
                        hashtable.put(n, n2);
                    }
                    catch (Exception exception) {
                        RAS.logInformation(19, 5, this, "discoverChildren exception", "ModuleLocation." + n.toString() + " not found in Property file");
                    }
                }
                boolean bl = true;
                int n = 0;
                while (n < vector2.size()) {
                    bl = bl && hashtable.contains(new Integer(n + 1));
                    ++n;
                }
                int n3 = 0;
                int n4 = 0;
                object3 = vector.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ModelInfo)object3.nextElement();
                    object = genModel.getRowRef((ModelInfo)object2);
                    GenModel genModel2 = (GenModel)object.getComponent("ModType");
                    GenModel genModel3 = (GenModel)genModel2.getComponent("Ports");
                    genModel2 = (GenModel)genModel2.getComponent("ModData");
                    object2 = genModel2.getInfo("Panel", "default", (ModelInfo)object2);
                    MibValue mibValue = (MibValue)vector2.elementAt(n4);
                    int[] nArray = mibValue.getIndexesArray();
                    Integer n5 = new Integer(nArray[0]);
                    ++n4;
                    int n6 = (Integer)mibValue.getValue();
                    n3 = bl ? (Integer)hashtable.get(n5) : ++n3;
                    ModuleLike moduleLike = Builder.getInstance().buildModule(this, this.jdmBrowser, this, this.graphicContainer, (ModelInfo)object2, n3, n5, n6, genModel3);
                    this.add(moduleLike);
                }
                if (!bl && RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "discoverChildren", "The user definition for stack positioning is incosistent. Defaults used.");
                }
            }
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 5, this, "discoverChildren", (Exception)remoteException);
        }
        if (RAS.isEnabled(19, 5)) {
            RAS.exit(19, 5, this, "discoverChildren");
        }
    }

    public void add(LeafCompositeLike leafCompositeLike) {
        this.components.addElement(leafCompositeLike);
    }

    public void setCommonInformation(JdmBrowser jdmBrowser, MibInfo mibInfo) {
        this.jdmBrowser = jdmBrowser;
        this.snmpInfo = mibInfo;
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("Configuration");
            genModel = (GenModel)genModel2.getComponent("Communications");
            genModel = (GenModel)genModel.getComponent("Media");
            genModel = (GenModel)genModel.getComponent("Mib2");
            this.interfaceGenModel = genModel = (GenModel)genModel.getComponent("Interface");
            this.interfaceModels = genModel.getRestOfInfo("Panel", "default", null, null);
            return;
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 5, this, "setCommonInformation", (Exception)remoteException);
            return;
        }
    }

    public void draw() {
        GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.jdmBrowser, new Point(0, 0), new HelpRef("ibm.nways.jdm8238", "ibm.nways.jdm8238.BoxGraphic.html"));
        this.container.add((GraphicComponent)graphicHelp);
        this.graphicContainer.setLocation(0, 20);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            long l = System.currentTimeMillis();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 5, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 5, this, "draw", exception);
            }
            long l2 = System.currentTimeMillis();
            if (!RAS.isEnabled(19, 5)) continue;
            RAS.trace(19, 5, this, "draw", "Time to draw component -> " + (l2 - l));
        }
        this.container.add(this.graphicContainer);
        this.graphicContainer.doLayout();
        this.container.doLayout();
    }

    public GraphicPanel getGraphicPanel() {
        if (this.graphicPanel == null) {
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)this.container);
        }
        return this.graphicPanel;
    }

    public String getIp() {
        String string = "";
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)((GenModel)this.jdmBrowser.getModel()).getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            string = (String)((Object)modelInfo.get("Config.Address"));
        }
        catch (Exception exception) {
            RAS.logException(19, 5, this, "getIp", exception);
        }
        return string;
    }

    protected ModelInfo getIfModelInfo(int n) {
        Enumeration enumeration = this.interfaceModels.elements();
        while (enumeration.hasMoreElements()) {
            ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
            if ((Integer)modelInfo.get("Index.IfIndex") != n) continue;
            return modelInfo;
        }
        return null;
    }

    protected int getIfType(int n) {
        ModelInfo modelInfo = this.getIfModelInfo(n);
        if (modelInfo == null) {
            return -1;
        }
        return (Integer)modelInfo.get("Panel.IfType");
    }

    public String getTRPortMACAddress(int n, int n2) {
        if (this.macAddressTokenRingPorts == null) {
            this.macAddressTokenRingPorts = this.createMacAddressAssignment();
        }
        boolean bl = false;
        int n3 = 1;
        String string = "";
        while (!bl) {
            Object v = this.macAddressTokenRingPorts.get("." + n + "." + n2 + "." + n3);
            if (v != null) {
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "getTRPortMACAddress", String.valueOf(n) + " " + n2);
                }
                ++n3;
                if (!string.equals("")) {
                    string = String.valueOf(string) + "\n";
                }
                string = String.valueOf(string) + (String)v;
                continue;
            }
            if (n3 == 1 && RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "getTRPortMACAddress", "NULL!!!! " + n + " " + n2);
            }
            bl = true;
        }
        return string;
    }

    private Hashtable createMacAddressAssignment() {
        if (RAS.isEnabled(19, 5)) {
            RAS.enter(19, 5, this, "createMacAddressAssignment");
        }
        Hashtable hashtable = new Hashtable();
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("TRSummaryInfo");
            Vector vector = genModel2.getRestOfInfo("TRSummaryInfo", "default", null, null);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                if (modelInfo == null) continue;
                Serializable serializable = modelInfo.get("TRSummaryInfo.MapSummary32Stations");
                if (serializable instanceof OctetString) {
                    byte[] byArray = ((OctetString)serializable).value;
                    String string = serializable.toString().toUpperCase();
                    int n = 0;
                    int n2 = 0;
                    try {
                        while (true) {
                            int n3 = byArray[n + 6] & 0xFF;
                            int n4 = byArray[n + 7] & 0xFF;
                            String string2 = string.substring(n2, n2 + 12);
                            n += 8;
                            n2 += 16;
                            if (RAS.isEnabled(19, 5)) {
                                RAS.trace(19, 5, this, "createMacAdressAssignment", String.valueOf(n3) + " " + n4);
                            }
                            this.addToHashTable(hashtable, n3, n4, string2);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        continue;
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 5, this, "createMacAddressAssignment", exception);
                        continue;
                    }
                }
                if (!RAS.isEnabled(19, 5)) continue;
                RAS.trace(19, 5, this, "createMacAddressAssignment", "Error when retrieving Token Ring MAC addresses");
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 5, this, "createMacAddressAssignment", exception);
        }
        if (RAS.isEnabled(19, 5)) {
            RAS.exit(19, 5, this, "createMacAddressAssignment");
        }
        return hashtable;
    }

    private void addToHashTable(Hashtable hashtable, int n, int n2, String string) {
        boolean bl = false;
        int n3 = 1;
        while (!bl) {
            Object v = hashtable.get("." + n + "." + n2 + "." + n3);
            if (v != null) {
                ++n3;
                continue;
            }
            bl = true;
        }
        hashtable.put("." + n + "." + n2 + "." + n3, string);
    }

    private void cleanMacAddressAssignment() {
        if (this.macAddressTokenRingPorts != null) {
            this.macAddressTokenRingPorts.clear();
            this.macAddressTokenRingPorts = null;
        }
    }

    public void startStatusThread(Chassis chassis) {
        this.stopStatusThread();
        this.statusThread = chassis.new StatusAttachThread();
        this.statusThread.setName("StatusAttach");
        this.statusThread.start();
    }

    public void stopStatusThread() {
        if (this.statusThread != null) {
            this.statusThread.stop();
            this.statusThread = null;
        }
    }

    public void askStatus(GenModel genModel, GraphicImage graphicImage, ModelInfo modelInfo, LeafCompositeLike leafCompositeLike) {
        this.stack.addElement(new StatusAttachInfo(genModel, graphicImage, modelInfo, leafCompositeLike));
    }

    public void askStatus(LateStatusLike lateStatusLike) {
        this.lateStack.addElement(lateStatusLike);
    }

    private class StatusAttachThread
    extends Thread {
        public void run() {
            Object object;
            if (RAS.isEnabled(19, 5)) {
                RAS.enter(19, 5, this, "run");
                RAS.trace(19, 5, this, "run", "Status thread running...");
            }
            Vector vector = Chassis.this.stack;
            synchronized (vector) {
                try {
                    int n = 0;
                    while (n < Chassis.this.stack.size()) {
                        object = (StatusAttachInfo)Chassis.this.stack.elementAt(n);
                        RemoteStatus remoteStatus = null;
                        remoteStatus = ((StatusAttachInfo)object).info != null ? ((StatusAttachInfo)object).model.getStatusRefForRow(((StatusAttachInfo)object).info) : ((StatusAttachInfo)object).model.getStatus("default");
                        StatusProxy statusProxy = new StatusProxy(remoteStatus);
                        ((StatusAttachInfo)object).image.setStatus((Status)statusProxy);
                        if (((StatusAttachInfo)object).object instanceof StatusRefLike) {
                            ((StatusRefLike)((Object)((StatusAttachInfo)object).object)).setStatusRef(statusProxy);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 5, this, "run", exception);
                }
            }
            Chassis.this.stack.removeAllElements();
            vector = Chassis.this.lateStack;
            synchronized (vector) {
                try {
                    int n = 0;
                    while (n < Chassis.this.lateStack.size()) {
                        object = (LateStatusLike)Chassis.this.lateStack.elementAt(n);
                        object.statusesAttached();
                        ++n;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 5, this, "run", exception);
                }
            }
            Chassis.this.lateStack.removeAllElements();
            if (RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "run", "End of status thread.");
                RAS.exit(19, 5, this, "run");
            }
        }

        StatusAttachThread() {
            Chassis.this = Chassis.this;
        }
    }
}

